{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2005 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2005 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

{*******************************************************}
{       Windows Messages and Types                      }
{*******************************************************}

unit Borland.Vcl.Messages platform;

interface

uses Windows, Types;

                                                    

{ Window Messages }

const
  WM_NULL             = $0000;
  WM_CREATE           = $0001;
  WM_DESTROY          = $0002;
  WM_MOVE             = $0003;
  WM_SIZE             = $0005;
  WM_ACTIVATE         = $0006;
  WM_SETFOCUS         = $0007;
  WM_KILLFOCUS        = $0008;
  WM_ENABLE           = $000A;
  WM_SETREDRAW        = $000B;
  WM_SETTEXT          = $000C;
  WM_GETTEXT          = $000D;
  WM_GETTEXTLENGTH    = $000E;
  WM_PAINT            = $000F;
  WM_CLOSE            = $0010;
  WM_QUERYENDSESSION  = $0011;
  WM_QUIT             = $0012;
  WM_QUERYOPEN        = $0013;
  WM_ERASEBKGND       = $0014;
  WM_SYSCOLORCHANGE   = $0015;
  WM_ENDSESSION       = $0016;
  WM_SYSTEMERROR      = $0017;
  WM_SHOWWINDOW       = $0018;
  WM_CTLCOLOR         = $0019;
  WM_WININICHANGE     = $001A;
  WM_SETTINGCHANGE = WM_WININICHANGE;
  WM_DEVMODECHANGE    = $001B;
  WM_ACTIVATEAPP      = $001C;
  WM_FONTCHANGE       = $001D;
  WM_TIMECHANGE       = $001E;
  WM_CANCELMODE       = $001F;
  WM_SETCURSOR        = $0020;
  WM_MOUSEACTIVATE    = $0021;
  WM_CHILDACTIVATE    = $0022;
  WM_QUEUESYNC        = $0023;
  WM_GETMINMAXINFO    = $0024;
  WM_PAINTICON        = $0026;
  WM_ICONERASEBKGND   = $0027;
  WM_NEXTDLGCTL       = $0028;
  WM_SPOOLERSTATUS    = $002A;
  WM_DRAWITEM         = $002B;
  WM_MEASUREITEM      = $002C;
  WM_DELETEITEM       = $002D;
  WM_VKEYTOITEM       = $002E;
  WM_CHARTOITEM       = $002F;
  WM_SETFONT          = $0030;
  WM_GETFONT          = $0031;
  WM_SETHOTKEY        = $0032;
  WM_GETHOTKEY        = $0033;
  WM_QUERYDRAGICON    = $0037;
  WM_COMPAREITEM      = $0039;
  WM_GETOBJECT        = $003D;
  WM_COMPACTING       = $0041;

  WM_COMMNOTIFY       = $0044;    { obsolete in Win32}

  WM_WINDOWPOSCHANGING = $0046;
  WM_WINDOWPOSCHANGED = $0047;
  WM_POWER            = $0048;

  WM_COPYDATA         = $004A;
  WM_CANCELJOURNAL    = $004B;
  WM_NOTIFY           = $004E;
  WM_INPUTLANGCHANGEREQUEST = $0050;
  WM_INPUTLANGCHANGE  = $0051;
  WM_TCARD            = $0052;
  WM_HELP             = $0053;
  WM_USERCHANGED      = $0054;
  WM_NOTIFYFORMAT     = $0055;

  WM_CONTEXTMENU      = $007B;
  WM_STYLECHANGING    = $007C;
  WM_STYLECHANGED     = $007D;
  WM_DISPLAYCHANGE    = $007E;
  WM_GETICON          = $007F;
  WM_SETICON          = $0080;

  WM_NCCREATE         = $0081;
  WM_NCDESTROY        = $0082;
  WM_NCCALCSIZE       = $0083;
  WM_NCHITTEST        = $0084;
  WM_NCPAINT          = $0085;
  WM_NCACTIVATE       = $0086;
  WM_GETDLGCODE       = $0087;
  WM_NCMOUSEMOVE      = $00A0;
  WM_NCLBUTTONDOWN    = $00A1;
  WM_NCLBUTTONUP      = $00A2;
  WM_NCLBUTTONDBLCLK  = $00A3;
  WM_NCRBUTTONDOWN    = $00A4;
  WM_NCRBUTTONUP      = $00A5;
  WM_NCRBUTTONDBLCLK  = $00A6;
  WM_NCMBUTTONDOWN    = $00A7;
  WM_NCMBUTTONUP      = $00A8;
  WM_NCMBUTTONDBLCLK  = $00A9;

  WM_NCXBUTTONDOWN = $00AB;
  WM_NCXBUTTONUP = $00AC;
  WM_NCXBUTTONDBLCLK = $00AD;
  WM_INPUT = $00FF;

  WM_KEYFIRST         = $0100;
  WM_KEYDOWN          = $0100;
  WM_KEYUP            = $0101;
  WM_CHAR             = $0102;
  WM_DEADCHAR         = $0103;
  WM_SYSKEYDOWN       = $0104;
  WM_SYSKEYUP         = $0105;
  WM_SYSCHAR          = $0106;
  WM_SYSDEADCHAR      = $0107;
  WM_KEYLAST          = $0108;

  WM_INITDIALOG       = $0110;
  WM_COMMAND          = $0111;
  WM_SYSCOMMAND       = $0112;
  WM_TIMER            = $0113;
  WM_HSCROLL          = $0114;
  WM_VSCROLL          = $0115;
  WM_INITMENU         = $0116;
  WM_INITMENUPOPUP    = $0117;
  WM_MENUSELECT       = $011F;
  WM_MENUCHAR         = $0120;
  WM_ENTERIDLE        = $0121;

  WM_MENURBUTTONUP    = $0122;
  WM_MENUDRAG         = $0123;
  WM_MENUGETOBJECT    = $0124;
  WM_UNINITMENUPOPUP  = $0125;
  WM_MENUCOMMAND      = $0126;

  WM_CHANGEUISTATE    = $0127;
  WM_UPDATEUISTATE    = $0128;
  WM_QUERYUISTATE     = $0129;

  WM_CTLCOLORMSGBOX   = $0132;
  WM_CTLCOLOREDIT     = $0133;
  WM_CTLCOLORLISTBOX  = $0134;
  WM_CTLCOLORBTN      = $0135;
  WM_CTLCOLORDLG      = $0136;
  WM_CTLCOLORSCROLLBAR= $0137;
  WM_CTLCOLORSTATIC   = $0138;

  WM_MOUSEFIRST       = $0200;
  WM_MOUSEMOVE        = $0200;
  WM_LBUTTONDOWN      = $0201;
  WM_LBUTTONUP        = $0202;
  WM_LBUTTONDBLCLK    = $0203;
  WM_RBUTTONDOWN      = $0204;
  WM_RBUTTONUP        = $0205;
  WM_RBUTTONDBLCLK    = $0206;
  WM_MBUTTONDOWN      = $0207;
  WM_MBUTTONUP        = $0208;
  WM_MBUTTONDBLCLK    = $0209;
  WM_MOUSEWHEEL       = $020A;
  WM_MOUSELAST        = $020A;

  WM_PARENTNOTIFY     = $0210;
  WM_ENTERMENULOOP    = $0211;
  WM_EXITMENULOOP     = $0212;
  WM_NEXTMENU         = $0213;

  WM_SIZING           = 532;
  WM_CAPTURECHANGED   = 533;
  WM_MOVING           = 534;
  WM_POWERBROADCAST   = 536;
  WM_DEVICECHANGE     = 537;

  WM_IME_STARTCOMPOSITION        = $010D;
  WM_IME_ENDCOMPOSITION          = $010E;
  WM_IME_COMPOSITION             = $010F;
  WM_IME_KEYLAST                 = $010F;

  WM_IME_SETCONTEXT              = $0281;
  WM_IME_NOTIFY                  = $0282;
  WM_IME_CONTROL                 = $0283;
  WM_IME_COMPOSITIONFULL         = $0284;
  WM_IME_SELECT                  = $0285;
  WM_IME_CHAR                    = $0286;
  WM_IME_REQUEST                 = $0288;

  WM_IME_KEYDOWN                 = $0290;
  WM_IME_KEYUP                   = $0291;

  WM_MDICREATE        = $0220;
  WM_MDIDESTROY       = $0221;
  WM_MDIACTIVATE      = $0222;
  WM_MDIRESTORE       = $0223;
  WM_MDINEXT          = $0224;
  WM_MDIMAXIMIZE      = $0225;
  WM_MDITILE          = $0226;
  WM_MDICASCADE       = $0227;
  WM_MDIICONARRANGE   = $0228;
  WM_MDIGETACTIVE     = $0229;
  WM_MDISETMENU       = $0230;

  WM_ENTERSIZEMOVE    = $0231;
  WM_EXITSIZEMOVE     = $0232;
  WM_DROPFILES        = $0233;
  WM_MDIREFRESHMENU   = $0234;

  WM_MOUSEHOVER       = $02A1;
  WM_MOUSELEAVE       = $02A3;

  WM_NCMOUSEHOVER     = $02A0;
  WM_NCMOUSELEAVE     = $02A2;
  WM_WTSSESSION_CHANGE = $02B1;

  WM_TABLET_FIRST     = $02C0;
  WM_TABLET_LAST      = $02DF;

  WM_CUT              = $0300;
  WM_COPY             = $0301;
  WM_PASTE            = $0302;
  WM_CLEAR            = $0303;
  WM_UNDO             = $0304;
  WM_RENDERFORMAT     = $0305;
  WM_RENDERALLFORMATS = $0306;
  WM_DESTROYCLIPBOARD = $0307;
  WM_DRAWCLIPBOARD    = $0308;
  WM_PAINTCLIPBOARD   = $0309;
  WM_VSCROLLCLIPBOARD = $030A;
  WM_SIZECLIPBOARD    = $030B;
  WM_ASKCBFORMATNAME  = $030C;
  WM_CHANGECBCHAIN    = $030D;
  WM_HSCROLLCLIPBOARD = $030E;
  WM_QUERYNEWPALETTE  = $030F;
  WM_PALETTEISCHANGING= $0310;
  WM_PALETTECHANGED   = $0311;
  WM_HOTKEY           = $0312;

  WM_PRINT            = 791;
  WM_PRINTCLIENT      = 792;
  WM_APPCOMMAND       = $0319;
  WM_THEMECHANGED     = $031A;

  WM_HANDHELDFIRST    = 856;
  WM_HANDHELDLAST     = 863;

  WM_PENWINFIRST      = $0380;
  WM_PENWINLAST       = $038F;

  WM_COALESCE_FIRST   = $0390;
  WM_COALESCE_LAST    = $039F;

  WM_DDE_FIRST        = $03E0;
  WM_DDE_INITIATE     = WM_DDE_FIRST + 0;
  WM_DDE_TERMINATE    = WM_DDE_FIRST + 1;
  WM_DDE_ADVISE       = WM_DDE_FIRST + 2;
  WM_DDE_UNADVISE     = WM_DDE_FIRST + 3;
  WM_DDE_ACK          = WM_DDE_FIRST + 4;
  WM_DDE_DATA         = WM_DDE_FIRST + 5;
  WM_DDE_REQUEST      = WM_DDE_FIRST + 6;
  WM_DDE_POKE         = WM_DDE_FIRST + 7;
  WM_DDE_EXECUTE      = WM_DDE_FIRST + 8;
  WM_DDE_LAST         = WM_DDE_FIRST + 8;

  WM_APP = $8000;

{ NOTE: All Message Numbers below 0x0400 are RESERVED }

{ Private Window Messages Start Here }

  WM_USER             = $0400;

{ Button Notification Codes }

const
  BN_CLICKED       = 0;
  BN_PAINT         = 1;
  BN_HILITE        = 2;
  BN_UNHILITE      = 3;
  BN_DISABLE       = 4;
  BN_DOUBLECLICKED = 5;
  BN_PUSHED = BN_HILITE;
  BN_UNPUSHED = BN_UNHILITE;
  BN_DBLCLK = BN_DOUBLECLICKED;
  BN_SETFOCUS = 6;
  BN_KILLFOCUS = 7;

{ Button Control Messages }
const
  BM_GETCHECK = $00F0;
  BM_SETCHECK = $00F1;
  BM_GETSTATE = $00F2;
  BM_SETSTATE = $00F3;
  BM_SETSTYLE = $00F4;
  BM_CLICK    = $00F5;
  BM_GETIMAGE = $00F6;
  BM_SETIMAGE = $00F7;

{ Listbox Notification Codes }

const
  LBN_ERRSPACE  = (-2);
  LBN_SELCHANGE = 1;
  LBN_DBLCLK    = 2;
  LBN_SELCANCEL = 3;
  LBN_SETFOCUS  = 4;
  LBN_KILLFOCUS = 5;

{ Listbox messages }

const
  LB_ADDSTRING            = $0180;
  LB_INSERTSTRING         = $0181;
  LB_DELETESTRING         = $0182;
  LB_SELITEMRANGEEX       = $0183;
  LB_RESETCONTENT         = $0184;
  LB_SETSEL               = $0185;
  LB_SETCURSEL            = $0186;
  LB_GETSEL               = $0187;
  LB_GETCURSEL            = $0188;
  LB_GETTEXT              = $0189;
  LB_GETTEXTLEN           = $018A;
  LB_GETCOUNT             = $018B;
  LB_SELECTSTRING         = $018C;
  LB_DIR                  = $018D;
  LB_GETTOPINDEX          = $018E;
  LB_FINDSTRING           = $018F;
  LB_GETSELCOUNT          = $0190;
  LB_GETSELITEMS          = $0191;
  LB_SETTABSTOPS          = $0192;
  LB_GETHORIZONTALEXTENT  = $0193;
  LB_SETHORIZONTALEXTENT  = $0194;
  LB_SETCOLUMNWIDTH       = $0195;
  LB_ADDFILE              = $0196;
  LB_SETTOPINDEX          = $0197;
  LB_GETITEMRECT          = $0198;
  LB_GETITEMDATA          = $0199;
  LB_SETITEMDATA          = $019A;
  LB_SELITEMRANGE         = $019B;
  LB_SETANCHORINDEX       = $019C;
  LB_GETANCHORINDEX       = $019D;
  LB_SETCARETINDEX        = $019E;
  LB_GETCARETINDEX        = $019F;
  LB_SETITEMHEIGHT        = $01A0;
  LB_GETITEMHEIGHT        = $01A1;
  LB_FINDSTRINGEXACT      = $01A2;
  LB_SETLOCALE            = $01A5;
  LB_GETLOCALE            = $01A6;
  LB_SETCOUNT             = $01A7;
  LB_INITSTORAGE          = $01A8;
  LB_ITEMFROMPOINT        = $01A9;
  LB_MSGMAX               = 432;

{ Combo Box Notification Codes }

const
  CBN_ERRSPACE   = (-1);
  CBN_SELCHANGE  = 1;
  CBN_DBLCLK     = 2;
  CBN_SETFOCUS   = 3;
  CBN_KILLFOCUS  = 4;
  CBN_EDITCHANGE = 5;
  CBN_EDITUPDATE = 6;
  CBN_DROPDOWN   = 7;
  CBN_CLOSEUP    = 8;
  CBN_SELENDOK   = 9;
  CBN_SELENDCANCEL = 10;

{ Combo Box messages }

  CB_GETEDITSEL            = $0140;
  CB_LIMITTEXT             = $0141;
  CB_SETEDITSEL            = $0142;
  CB_ADDSTRING             = $0143;
  CB_DELETESTRING          = $0144;
  CB_DIR                   = $0145;
  CB_GETCOUNT              = $0146;
  CB_GETCURSEL             = $0147;
  CB_GETLBTEXT             = $0148;
  CB_GETLBTEXTLEN          = $0149;
  CB_INSERTSTRING          = $014A;
  CB_RESETCONTENT          = $014B;
  CB_FINDSTRING            = $014C;
  CB_SELECTSTRING          = $014D;
  CB_SETCURSEL             = $014E;
  CB_SHOWDROPDOWN          = $014F;
  CB_GETITEMDATA           = $0150;
  CB_SETITEMDATA           = $0151;
  CB_GETDROPPEDCONTROLRECT = $0152;
  CB_SETITEMHEIGHT         = $0153;
  CB_GETITEMHEIGHT         = $0154;
  CB_SETEXTENDEDUI         = $0155;
  CB_GETEXTENDEDUI         = $0156;
  CB_GETDROPPEDSTATE       = $0157;
  CB_FINDSTRINGEXACT       = $0158;
  CB_SETLOCALE             = 345;
  CB_GETLOCALE             = 346;
  CB_GETTOPINDEX           = 347;
  CB_SETTOPINDEX           = 348;
  CB_GETHORIZONTALEXTENT   = 349;
  CB_SETHORIZONTALEXTENT   = 350;
  CB_GETDROPPEDWIDTH       = 351;
  CB_SETDROPPEDWIDTH       = 352;
  CB_INITSTORAGE           = 353;
  CB_MSGMAX                = 354;

{ Edit Control Notification Codes }

const
  EN_SETFOCUS  = $0100;
  EN_KILLFOCUS = $0200;
  EN_CHANGE    = $0300;
  EN_UPDATE    = $0400;
  EN_ERRSPACE  = $0500;
  EN_MAXTEXT   = $0501;
  EN_HSCROLL   = $0601;
  EN_VSCROLL   = $0602;

{ Edit Control Messages }

const
  EM_GETSEL              = $00B0;
  EM_SETSEL              = $00B1;
  EM_GETRECT             = $00B2;
  EM_SETRECT             = $00B3;
  EM_SETRECTNP           = $00B4;
  EM_SCROLL              = $00B5;
  EM_LINESCROLL          = $00B6;
  EM_SCROLLCARET         = $00B7;
  EM_GETMODIFY           = $00B8;
  EM_SETMODIFY           = $00B9;
  EM_GETLINECOUNT        = $00BA;
  EM_LINEINDEX           = $00BB;
  EM_SETHANDLE           = $00BC;
  EM_GETHANDLE           = $00BD;
  EM_GETTHUMB            = $00BE;
  EM_LINELENGTH          = $00C1;
  EM_REPLACESEL          = $00C2;
  EM_GETLINE             = $00C4;
  EM_LIMITTEXT           = $00C5;
  EM_CANUNDO             = $00C6;
  EM_UNDO                = $00C7;
  EM_FMTLINES            = $00C8;
  EM_LINEFROMCHAR        = $00C9;
  EM_SETTABSTOPS         = $00CB;
  EM_SETPASSWORDCHAR     = $00CC;
  EM_EMPTYUNDOBUFFER     = $00CD;
  EM_GETFIRSTVISIBLELINE = $00CE;
  EM_SETREADONLY         = $00CF;
  EM_SETWORDBREAKPROC    = $00D0;
  EM_GETWORDBREAKPROC    = $00D1;
  EM_GETPASSWORDCHAR     = $00D2;
  EM_SETMARGINS          = 211;
  EM_GETMARGINS          = 212;
  EM_SETLIMITTEXT        = EM_LIMITTEXT;    //win40 Name change
  EM_GETLIMITTEXT        = 213;
  EM_POSFROMCHAR         = 214;
  EM_CHARFROMPOS         = 215;
  EM_SETIMESTATUS        = 216;
  EM_GETIMESTATUS        = 217;

const
  { Scroll bar messages }
  SBM_SETPOS = 224;             { not in win3.1  }
  SBM_GETPOS = 225;             { not in win3.1  }
  SBM_SETRANGE = 226;           { not in win3.1  }
  SBM_SETRANGEREDRAW = 230;     { not in win3.1  }
  SBM_GETRANGE = 227;           { not in win3.1  }
  SBM_ENABLE_ARROWS = 228;      { not in win3.1  }
  SBM_SETSCROLLINFO = 233;
  SBM_GETSCROLLINFO = 234;

{ Dialog messages }

  DM_GETDEFID = (WM_USER+0);
  DM_SETDEFID = (WM_USER+1);
  DM_REPOSITION = (WM_USER+2);

  PSM_PAGEINFO = (WM_USER+100);
  PSM_SHEETINFO = (WM_USER+101);

type

{ Generic window message record }

  TMessageCracker = class;

  TMessageBase = class(TObject)
  protected
    procedure Invalid;
  protected
    // Stub implementation for the IConvertable interface
    function GetTypeCode: TypeCode;
    function ToBoolean(Provider: IFormatProvider): Boolean;
    function ToByte(Provider: IFormatProvider): Byte;
    function ToChar(Provider: IFormatProvider): Char;
    function ToDateTime(Provider: IFormatProvider): DateTime;
    function ToDecimal(Provider: IFormatProvider): Decimal;
    function ToDouble(Provider: IFormatProvider): Double;
    function ToInt16(Provider: IFormatProvider): SmallInt;
    function ToInt32(Provider: IFormatProvider): Integer;
    function ToInt64(Provider: IFormatProvider): Int64;
    function ToSByte(Provider: IFormatProvider): ShortInt;
    function ToSingle(Provider: IFormatProvider): Single;
    function ToString(Provider: IFormatProvider): string; reintroduce; overload;
    function ToType(ToType: System.Type; Provider: IFormatProvider): TObject;
    function ToUInt16(Provider: IFormatProvider): Word;
    function ToUInt32(Provider: IFormatProvider): Cardinal;
    function ToUInt64(Provider: IFormatProvider): UInt64;
  end;

  TMessage = class(TMessageBase, IConvertible)
  private
    function GetLParamHi: Word;
    function GetLParamLo: Word;
    function GetWParamHi: Word;
    function GetWParamLo: Word;
    procedure SetLParamHi(const Value: Word);
    procedure SetLParamLo(const Value: Word);
    procedure SetWParamHi(const Value: Word);
    procedure SetWParamLo(const Value: Word);
  protected
    function ToType(ToType: System.Type; Provider: IFormatProvider): TObject;
  public
    Msg: Integer;
    WParam: Integer;
    LParam: Integer;
    Result: Integer;
    constructor Create; overload;
    constructor Create(Msg: Cardinal; WParam: Integer; LParam: Integer); overload;
    constructor Create(Message: TMessageCracker); overload;
    constructor Create(Message: TMessage); overload;
    property WParamLo: Word read GetWParamLo write SetWParamLo;
    property WParamHi: Word read GetWParamHi write SetWParamHi;
    property LParamLo: Word read GetLParamLo write SetLParamLo;
    property LParamHi: Word read GetLParamHi write SetLParamHi;
  end;

  LPSTR = string;

  TMessageCracker = class
  private
    FMessage: TMessage;
  protected
    function GetLParam: Integer;
    function GetLParamBool: LongBool;
    function GetLParamHandle: THandle;
    function GetLParamHICON: HICON;
    function GetLParamHMENU: HMENU;
    function GetLParamHWND: HWND;
    function GetLParamLPSTR: LPSTR;
    function GetLParamHi: Word;
    function GetLParamLo: Word;
    function GetLParamHiSmall: SmallInt;
    function GetLParamLoSmall: SmallInt;
    function GetLParamHiWordBool: WordBool;
    function GetLParamLoWordBool: WordBool;
    function GetMsg: Cardinal;
    function GetResult: Integer;
    function GetWParam: Integer;
    function GetWParamBool: LongBool;
    function GetWParamHDC: HDC;
    function GetWParamHFONT: HFONT;
    function GetWParamHMENU: HMENU;
    function GetWParamHRGN: HRGN;
    function GetWParamHWND: HWND;
    function GetWParamLPSTR: LPSTR;
    function GetWParamHandle: THandle;
    function GetWParamHi: Word;
    function GetWParamLo: Word;
    function GetWParamHiSmall: SmallInt;
    function GetWParamLoSmall: SmallInt;
    function GetWParamHiWordBool: WordBool;
    function GetWParamLoWordBool: WordBool;
    procedure SetLParam(const Value: Integer);
    procedure SetLParamBool(const Value: LongBool);
    procedure SetLParamHandle(const Value: THandle);
    procedure SetLParamHICON(const Value: HICON);
    procedure SetLParamHMENU(const Value: HMENU);
    procedure SetLParamHWND(const Value: HWND);
    procedure SetLParamLPSTR(const Value: LPSTR);
    procedure SetLParamHi(const Value: Word);
    procedure SetLParamLo(const Value: Word);
    procedure SetLParamHiSmall(const Value: SmallInt);
    procedure SetLParamLoSmall(const Value: SmallInt);
    procedure SetLParamHiWordBool(const Value: WordBool);
    procedure SetLParamLoWordBool(const Value: WordBool);
    procedure SetMsg(const Value: Cardinal);
    procedure SetResult(const Value: Integer);
    procedure SetWParam(const Value: Integer);
    procedure SetWParamBool(const Value: LongBool);
    procedure SetWParamHDC(const Value: HDC);
    procedure SetWParamHFONT(const Value: HFONT);
    procedure SetWParamHMENU(const Value: HMENU);
    procedure SetWParamHRGN(const Value: HRGN);
    procedure SetWParamHWND(const Value: HWND);
    procedure SetWParamLPSTR(const Value: LPSTR);
    procedure SetWParamHandle(const Value: THandle);
    procedure SetWParamHi(const Value: Word);
    procedure SetWParamLo(const Value: Word);
    procedure SetWParamHiSmall(const Value: SmallInt);
    procedure SetWParamLoSmall(const Value: SmallInt);
    procedure SetWParamHiWordBool(const Value: WordBool);
    procedure SetWParamLoWordBool(const Value: WordBool);
  protected
    property Msg: Cardinal read GetMsg write SetMsg;
    property WParam: Integer read GetWParam write SetWParam;
    property LParam: Integer read GetLParam write SetLParam;
    property Result: Integer read GetResult write SetResult;
    property WParamLo: Word read GetWParamLo write SetWParamLo;
    property WParamHi: Word read GetWParamHi write SetWParamHi;
    property LParamLo: Word read GetLParamLo write SetLParamLo;
    property LParamHi: Word read GetLParamHi write SetLParamHi;
  public
    constructor Create; overload;
    constructor Create(Message: TMessage); overload;
    property OriginalMessage: TMessage read FMessage;
  end;

{ Common message format records }

  TWMNoParams = class(TMessageCracker)
  public
    property Msg;
    property Result;
  end;

  TWMKey = class(TWMNoParams)
  public
    property CharCode: Word read GetWParamLo write SetWParamLo;
    property KeyData: Integer read GetLParam write SetLParam;
  end;

  TWMPosition = class(TWMNoParams)
  protected
    function GetSmallPoint: TSmallPoint;
    procedure SetSmallPoint(Value: TSmallPoint);
  public
    property XPos: SmallInt read GetLParamLoSmall write SetLParamLoSmall;
    property YPos: SmallInt read GetLParamHiSmall write SetLParamHiSmall;
    property Pos: TSmallPoint read GetSmallPoint write SetSmallPoint;
  end;

  TWMMouse = class(TWMPosition)
    property Keys: Integer read GetWParam write SetWParam;
  end;

  TWMMouseWheel = class(TWMPosition)
  public
    property Keys: SmallInt read GetWParamLoSmall write SetWParamLoSmall;
    property WheelDelta: SmallInt read GetWParamHiSmall write SetWParamHiSmall;
  end;

  TMSHMouseWheel = class(TWMPosition)
  public
    property WheelDelta: Integer read GetWParam write SetWParam;
  end;

  TWMWindowPosMsg = class(TWMNoParams)
  protected
    function GetWindowPos: TWindowPos;
    procedure SetWindowPos(Value: TWindowPos);
    function GetWindowPosIsNil: Boolean;
  public
    property WindowPosIsNil: Boolean read GetWindowPosIsNil;
    property WindowPos: TWindowPos read GetWindowPos write SetWindowPos;
  end;

  TWMScroll = class(TWMNoParams)
  public
    property ScrollCode: SmallInt read GetWParamLoSmall write SetWParamLoSmall;
    property Pos: SmallInt read GetWParamHiSmall write SetWParamHiSmall;
    property ScrollBar: HWND read GetLParamHWND write SetLParamHWND;
  end;

  TWMActivate = class(TWMNoParams)
  public
    property Active: Word read GetWParamLo write SetWParamLo; { WA_INACTIVE, WA_ACTIVE, WA_CLICKACTIVE }
    property Minimized: WordBool read GetWParamHiWordBool write SetWParamHiWordBool;
    property ActiveWindow: HWND read GetLParamHWND write SetLParamHWND;
  end;

  TWMActivateApp = class(TWMNoParams)
  public
    property Active: LongBool read GetWParamBool write SetWParamBool;
    property ThreadId: Integer read GetLParam write SetLParam;
  end;

  TWMAskCBFormatName = class(TWMNoParams)
  public
    property NameLen: Word read GetWParamLo write SetWParamLo;
    property FormatName: LPSTR read GetLParamLPSTR write SetLParamLPSTR;
  end;

  TWMCancelMode = TWMNoParams;

  TWMChangeCBChain = class(TWMNoParams)
  public
    property Remove: HWND read GetWParamHWND write SetWParamHWND;
    property Next: HWND read GetLParamHWND write SetLParamHWND;
  end;

  TWMChar = TWMKey;

  TWMCharToItem = class(TWMNoParams)
  public
    property Key: Word read GetWParamLo write SetWParamLo;
    property CaretPos: Word read GetWParamHi write SetWParamHi;
    property ListBox: HWND read GetLParamHWND write SetLParamHWND;
  end;

  TWMChildActivate = TWMNoParams;

  /// when using TWMChooseFont, you must marshal the LogFont pointer!

  TWMChooseFont_GetLogFont = class(TWMNoParams)
  protected
    function GetLogFont: IntPtr;
    procedure SetLogFont(const Value: IntPtr);
  public
    property LogFont: IntPtr read GetLogFont write SetLogFont;
  end;

  TWMClear = TWMNoParams;
  TWMClose = TWMNoParams;

  TWMCommand = class(TWMNoParams)
  public
    property ItemID: Word read GetWParamLo write SetWParamLo;
    property NotifyCode: Word read GetWParamHi write SetWParamHi;
    property Ctl: HWND read GetLParamHWND write SetLParamHWND;
  end;

  TWMCompacting = class(TWMNoParams)
  public
    property CompactRatio: Integer read GetWParam write SetWParam;
  end;

  TWMCompareItem = class(TWMNoParams)
  protected
    function GetCompareItemStruct: TCompareItemStruct;
    procedure SetCompareItemStruct(Value: TCompareItemStruct);
  public
    property Ctl: HWND read GetWParamHWND write SetWParamHWND;
    property CompareItemStruct: TCompareItemStruct read GetCompareItemStruct write SetCompareItemStruct;
  end;

  TWMCopy = TWMNoParams;

  TWMCopyData = class(TWMNoParams)
  protected
    function GetCopyDataStruct: TCopyDataStruct;
    procedure SetCopyDataStruct(const Value: TCopyDataStruct);
  public
    property From: HWND read GetWParamHWND write SetWParamHWND;
    property CopyDataStruct: TCopyDataStruct read GetCopyDataStruct write SetCopyDataStruct;
  end;

  { ?? WM_CLP_LAUNCH, WM_CPL_LAUNCHED }

  TWMCreate = class(TWMNoParams)
  protected
    function GetCreateStruct: TCreateStruct;
    procedure SetCreateStruct(const Value: TCreateStruct);
  public
    property CreateStruct: TCreateStruct read GetCreateStruct write SetCreateStruct;
  end;

  TWMCtlColor = class(TWMNoParams)
  public
    property ChildDC: HDC read GetWParamHDC write SetWParamHDC;
    property ChildWnd: HWND read GetLParamHWND write SetLParamHWND;
  end;

  TWMCtlColorBtn = TWMCtlColor;
  TWMCtlColorDlg = TWMCtlColor;
  TWMCtlColorEdit = TWMCtlColor;
  TWMCtlColorListbox = TWMCtlColor;
  TWMCtlColorMsgbox = TWMCtlColor;
  TWMCtlColorScrollbar = TWMCtlColor;
  TWMCtlColorStatic = TWMCtlColor;

  TWMCut = TWMNoParams;

  TWMDDEMessage = class(TWMNoParams)
  public
    property PostingApp: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMDDE_Ack = class(TWMDDEMessage)
  public
    // For WM_DDE_Initiate Ack
    property App: Word read GetLParamLo write SetLParamLo;
    property Topic: Word read GetLParamHi write SetLParamHi;

    // All other Ack's
    property PackedVal: Integer read GetLParam write SetLParam;
  end;

  TWMDDEDataMessage = class(TWMDDEMessage)
  public
    property PackedVal: Integer read GetLParam write SetLParam;
  end;

  TWMDDE_Advise = TWMDDEDataMessage;
  TWMDDE_Data = TWMDDEDataMessage;

  TWMDDE_Execute = class(TWMDDEMessage)
  public
    property Command: THandle read GetLParamHandle write SetLParamHandle;
  end;

  TWMDDE_Initiate = class(TWMDDEMessage)
  public
    property App: Word read GetLParamLo write SetLParamLo;
    property Topic: Word read GetLParamHi write SetLParamHi;
  end;

  TWMDDE_Poke = TWMDDEDataMessage;

  TWMDDEDataRequest = class(TWMDDEMessage)
  public
    property Format: Word read GetLParamLo write SetLParamLo;
    property Item: Word read GetLParamHi write SetLParamHi;
  end;

  TWMDDE_Request = TWMDDEDataRequest;
  TWMDDE_Terminate = TWMDDEMessage;
  TWMDDE_Unadvise = TWMDDEDataRequest;

  TWMDeadChar = TWMChar;

  TWMDeleteItem = class(TWMNoParams)
  protected
    function GetDeleteItemStruct: TDeleteItemStruct;
    procedure SetDeleteItemStruct(Value: TDeleteItemStruct);
  public
    property Ctl: HWND read GetWParamHWND write SetWParamHWND;
    property DeleteItemStruct: TDeleteItemStruct read GetDeleteItemStruct write SetDeleteItemStruct;
  end;

  TWMDestroy = TWMNoParams;
  TWMDestroyClipboard = TWMNoParams;

  TWMDevModeChange = class(TWMNoParams)
  public
    property Device: LPSTR read GetLParamLPSTR write SetLParamLPSTR;
  end;

  TWMDrawClipboard = TWMNoParams;

  TWMDrawItem = class(TWMNoParams)
  protected
    function GetDrawItemStruct: TDrawItemStruct;
    procedure SetDrawItemStruct(Value: TDrawItemStruct);
  public
    property Ctl: HWND read GetWParamHWND write SetWParamHWND;
    property DrawItemStruct: TDrawItemStruct read GetDrawItemStruct write SetDrawItemStruct;
  end;

  TWMDropFiles = class(TWMNoParams)
  public
    property Drop: THandle read GetWParamHandle write SetWParamHandle;
  end;

  TWMEnable = class(TWMNoParams)
  public
    property Enabled: LongBool read GetWParamBool write SetWParamBool;
  end;

  TWMEndSession = class(TWMNoParams)
  public
    property EndSession: LongBool read GetWParamBool write SetWParamBool;
  end;

  TWMEnterIdle = class(TWMNoParams)
  public
    property Source: Integer read GetWParam write SetWParam;  { MSGF_DIALOGBOX, MSGF_MENU }
    property Idle: HWND read GetLParamHWND write SetLParamHWND;
  end;

  TWMMenuLoop = class(TWMNoParams)
  public
    property IsTrackPopup: LongBool read GetWParamBool write SetWParamBool;
  end;

  TWMEnterMenuLoop = TWMMenuLoop;
  TWMExitMenuLoop = TWMMenuLoop;

  TWMEraseBkgnd = class(TWMNoParams)
  public
    property DC: HDC read GetWParamHDC write SetWParamHDC;
  end;

  TWMFontChange = TWMNoParams;
  TWMGetDlgCode = TWMNoParams;
  TWMGetFont = TWMNoParams;

  TWMGetIcon = class(TWMNoParams)
  public
    property BigIcon: LongBool read GetWParamBool write SetWParamBool;
  end;

  TWMGetHotKey = TWMNoParams;

  TWMGetMinMaxInfo = class(TWMNoParams)
  protected
    function GetMinMaxInfo: TMinMaxInfo;
    procedure SetMinMaxInfo(Value: TMinMaxInfo);
  public
    property MinMaxInfo: TMinMaxInfo read GetMinMaxInfo write SetMinMaxInfo;
  end;

  TWMGetText = class(TWMNoParams)
  public
    property TextMax: Integer read GetWParam write SetWParam;
    property Text: LPSTR read GetLParamLPSTR write SetLParamLPSTR;
  end;

  TWMGetTextLength = TWMNoParams;

  TWMHotKey = class(TWMNoParams)
  public
    property HotKey: Integer read GetWParam write SetWParam;
  end;

  TWMHScroll = TWMScroll;

  TWMHScrollClipboard = class(TWMNoParams)
  public
    property Viewer: HWND read GetWParamHWND write SetWParamHWND;
    property ScrollCode: Word read GetLParamLo write SetLParamLo;
    property Pos: Word read GetLParamHi write SetLParamHi;
  end;

  TWMIconEraseBkgnd = TWMEraseBkgnd;

  TWMInitDialog = class(TWMNoParams)
  public
    property Focus: HWND read GetWParamHWND write SetWParamHWND;
    property InitParam: Integer read GetLParam write SetLParam;
  end;

  TWMInitMenu = class(TWMNoParams)
  public
    property Menu: HMENU read GetWParamHMENU write SetWParamHMENU;
  end;

  TWMInitMenuPopup = class(TWMInitMenu)
  public
    property MenuPopup: HMENU read GetWParamHMENU write SetWParamHMENU;
    property Pos: Smallint read GetLParamLoSmall write SetLParamLoSmall;
    property SystemMenu: WordBool read GetLParamHiWordBool write SetLParamHiWordBool;
  end;

  TWMKeyDown = TWMKey;
  TWMKeyUp = TWMKey;

  TWMKillFocus = class(TWMNoParams)
  public
    property FocusedWnd: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMLButtonDblClk = TWMMouse;
  TWMLButtonDown   = TWMMouse;
  TWMLButtonUp     = TWMMouse;
  TWMMButtonDblClk = TWMMouse;
  TWMMButtonDown   = TWMMouse;
  TWMMButtonUp     = TWMMouse;

{$IFNDEF CF}
  TWMMDIActivate = class(TWMNoParams)
  public
    property ChildWnd: HWND read GetWParamHWND write SetWParamHWND;

    property DeactiveWnd: HWND read GetWParamHWND write SetWParamHWND;
    property ActiveWnd: HWND read GetLParamHWND write SetLParamHWND;
  end;

  TWMMDICascade = class(TWMNoParams)
  public
    property Cascade: Integer read GetWParam write SetWParam;   { 0, MDITILE_SKIPDISABLED }
  end;

  TWMMDICreate = class(TWMNoParams)
  protected
    function GetMDICreateStruct: TMDICreateStruct;
    procedure SetMDICreateStruct(Value: TMDICreateStruct);
  public
    property MDICreateStruct: TMDICreateStruct read GetMDICreateStruct write SetMDICreateStruct;
  end;

  TWMMDIDestroy = class(TWMNoParams)
  public
    property Child: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMMDIGetActive = TWMNoParams;
  TWMMDIIconArrange = TWMNoParams;

  TWMMDIMaximize = class(TWMNoParams)
  public
    property Maximize: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMMDINext = class(TWMNoParams)
  public
    property Child: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMMDIRefreshMenu = TWMNoParams;

  TWMMDIRestore = class(TWMNoParams)
  public
    property IDChild: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMMDISetMenu = class(TWMNoParams)
  public
    property MenuFrame: HMENU read GetWParamHMENU write SetWParamHMENU;
    property MenuWindow: HMENU read GetLParamHMENU write SetLParamHMENU;
  end;

  TWMMDITile = class(TWMNoParams)
  public
    property Tile: Integer read GetWParam write SetWParam;   { MDITILE_HORIZONTAL, MDITILE_SKIPDISABLE,
                                                               MDITILE_VERTICAL }
  end;
{$ENDIF}

  TWMMeasureItem = class(TWMNoParams)
  protected
    function GetMeasureItemStruct: TMeasureItemStruct;
    procedure SetMeasureItemStruct(Value: TMeasureItemStruct);
  public
    property IDCtl: HWND read GetWParamHWND write SetWParamHWND;
    property MeasureItemStruct: TMeasureItemStruct read GetMeasureItemStruct write SetMeasureItemStruct;
  end;


  TWMMenuChar = class(TWMNoParams)
  protected
    function GetChar: Char;
    procedure SetChar(const Value: Char);
  public
    property User: Char read GetChar write SetChar;
    property MenuFlag: Word read GetWParamHi write SetWParamHi;   { MF_POPUP, MF_SYSMENU }
    property Menu: HMENU read GetLParamHMENU write SetLParamHMENU;
  end;

  TWMMenuSelect = class(TWMNoParams)
  public
    property IDItem: Word read GetWParamLo write SetWParamLo;
    property MenuFlag: Word read GetWParamHi write SetWParamHi; { MF_BITMAP, MF_CHECKED, MF_DISABLED, MF_GRAYED,
                                                                  MF_MOUSESELECT, MF_OWNERDRAW, MF_POPUP, MF_SEPARATOR,
                                                                  MF_SYSMENU }

    property Menu: HMENU read GetLParamHMENU write SetLParamHMENU;
  end;

  TWMMouseActivate = class(TWMNoParams)
  public
    property TopLevel: HWND read GetWParamHWND write SetWParamHWND;
    property HitTestCode: Word read GetLParamLo write SetLParamLo;
    property MouseMsg: Word read GetLParamHi write SetLParamHi;
  end;

  TWMMouseMove = TWMMouse;
  TWMMove = TWMPosition;

  TWMMoving = class(TWMNoParams)
  protected
    function GetRect: TRect;
    procedure SetRect(const Value: TRect);
  public
    property Edge: Integer read GetWParam write SetWParam;
    property DragRect: TRect read GetRect write SetRect;
  end;

  TWMNCActivate = class(TWMNoParams)
  public
    property Active: LongBool read GetWParamBool write SetWParamBool;
  end;

  TWMNCCalcSize = class(TWMNoParams)
  protected
    function GetNCCalcSizeParams: TNCCalcSizeParams;
    procedure SetNCCalcSizeParams(Value: TNCCalcSizeParams);
  public
    property CalcValidRects: LongBool read GetWParamBool write SetWParamBool;
    property CalcSize_Params: TNCCalcSizeParams read GetNCCalcSizeParams write SetNCCalcSizeParams;
  end;

  TWMNCCreate = class(TWMNoParams)
  protected
    function GetCreateStruct: TCreateStruct;
    procedure SetCreateStruct(const Value: TCreateStruct);
  public
    property CreateStruct: TCreateStruct read GetCreateStruct write SetCreateStruct;
  end;

  TWMNCDestroy = TWMNoParams;
  TWMNCHitTest = TWMPosition;

  TWMNCHitMessage = class(TWMNoParams)
  public
    property HitTest: Integer read GetWParam write SetWParam;
    property XCursor: Smallint read GetLParamLoSmall write SetLParamLoSmall;
    property YCursor: Smallint read GetLParamHiSmall write SetLParamHiSmall;
  end;

  TWMNCLButtonDblClk = TWMNCHitMessage;
  TWMNCLButtonDown   = TWMNCHitMessage;
  TWMNCLButtonUp     = TWMNCHitMessage;
  TWMNCMButtonDblClk = TWMNCHitMessage;
  TWMNCMButtonDown   = TWMNCHitMessage;
  TWMNCMButtonUp     = TWMNCHitMessage;
  TWMNCMouseMove     = TWMNCHitMessage;

  TWMNCPaint = class(TWMNoParams)
  public
    property RGN: HRGN read GetWParamHRGN write SetWParamHRGN;
  end;

  TWMNCRButtonDblClk = TWMNCHitMessage;
  TWMNCRButtonDown   = TWMNCHitMessage;
  TWMNCRButtonUp     = TWMNCHitMessage;

  TWMNextDlgCtl = class(TWMNoParams)
  public
    property CtlFocus: Integer read GetWParam write SetWParam;
    property Handle: WordBool read GetLParamLoWordBool write SetLParamLoWordBool;
  end;

  TWMNotify = class(TWMNoParams)
  protected
    function GetNMHdr: TNMHdr;
    procedure SetNMHdr(Value: TNMHdr);
  public
    property IDCtrl: Integer read GetWParam write SetWParam;
    property NMHdr: TNMHdr read GetNMHdr write SetNMHdr;
  end;

  TWMNotifyFormat = class(TWMNoParams)
  public
    property From: HWND read GetWParamHWND write SetWParamHWND;
    property Command: Integer read GetLParam write SetLParam;
  end;

  TWMPaint = class(TWMNoParams)
  public
    property DC: HDC read GetWParamHDC write SetWParamHDC;
  end;

  TWMPaintClipboard = class(TWMNoParams)
  public
    property Viewer: HWND read GetWParamHWND write SetWParamHWND;
    property PaintStruct: THandle read GetLParamHandle write SetLParamHandle;
  end;

  TWMPaintIcon = TWMNoParams;

  TWMPaletteChanged = class(TWMNoParams)
  public
    property PalChg: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMPaletteIsChanging = class(TWMNoParams)
  public
    property Realize: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMParentNotify = class(TWMNoParams)
  public
    property Event: Word read GetWParamLo write SetWParamLo;

    { Event = WM_CREATE, WM_DESTROY}
    property ChildID: Word read GetWParamHi write SetWParamHi;
    property ChildWnd: HWND read GetLParamHWND write SetLParamHWND;

    { Event = WM_LBUTTONDOWN, WM_MBUTTONDOWN, WM_RBUTTONDOWN }
    property Value: Word read GetWParamHi write SetWParamHi;
    property XPos: Smallint read GetLParamLoSmall write SetLParamLoSmall;
    property YPos: Smallint read GetLParamHiSmall write SetLParamHiSmall;

    { All others }
    property Value1: Word read GetWParamHi write SetWParamHi;
    property Value2: Integer read GetLParam write SetLParam;
  end;

  TWMPaste = TWMNoParams;

  TWMPower = class(TWMNoParams)
  public
    property PowerEvt: Integer read GetWParam write SetWParam; { PWR_SUSPENDREQUEST, PWR_SUSPENDRESUME,
                                                                 PWR_CRITICALRESUME }
  end;

  TWMQueryDragIcon = TWMNoParams;

  TWMQueryEndSession = class(TWMNoParams)
  public
    property Source: Integer read GetWParam write SetWParam;
  end;

  TWMQueryNewPalette = TWMNoParams;
  TWMQueryOpen = TWMNoParams;
  TWMQueueSync = TWMNoParams;

  TWMQuit = class(TWMNoParams)
  public
    property ExitCode: Integer read GetWParam write SetWParam;
  end;
                                                    
  TWMRButtonDblClk = TWMMouse;
  TWMRButtonDown = TWMMouse;
  TWMRButtonUp = TWMMouse;

  TWMRenderAllFormats = TWMNoParams;

  TWMRenderFormat = class(TWMNoParams)
  public
    property Foramt: Integer read GetWParam write SetWParam;
  end;

  TWMSetCursor = class(TWMNoParams)
  public
    property CursorWnd: HWND read GetWParamHWND write SetWParamHWND;
    property HitTest: SmallInt read GetLParamLoSmall write SetLParamLoSmall;
    property MouseMsg: Word read GetLParamHi write SetLParamHi;
  end;

  TWMSetFocus = class(TWMNoParams)
  public
    property FocusedWnd: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMSetFont = class(TWMNoParams)
  public
    property Font: HFONT read GetWParamHFONT write SetWParamHFONT;
    property Redraw: WordBool read GetLParamLoWordBool write SetLParamLoWordBool;
  end;

  TWMSetHotKey = class(TWMNoParams)
  public
    property Key: Integer read GetWParam write SetWParam;
  end;

  TWMSetIcon = class(TWMNoParams)
  public
    property BigIcon: LongBool read GetWParamBool write SetWParamBool;
    property Icon: HICON read GetLParamHICON write SetLParamHICON;
  end;

  TWMSetRedraw = class(TWMNoParams)
  public
    property Redraw: Integer read GetWParam write SetWParam;
  end;

  TWMSetText = class(TWMNoParams)
  public
    property Text: LPSTR read GetLParamLPSTR write SetLParamLPSTR;
  end;

  TWMShowWindow = class(TWMNoParams)
  public
    property Show: LongBool read GetWParamBool write SetWParamBool;
    property Status: Integer read GetLParam write SetLParam;
  end;

  TWMSize = class(TWMNoParams)
  public
    property SizeType: Integer read GetWParam write SetWParam; { SIZE_MAXIMIZED, SIZE_MINIMIZED, SIZE_RESTORED,
                                                                 SIZE_MAXHIDE, SIZE_MAXSHOW }
    property Width: Word read GetLParamLo write SetLParamLo;
    property Height: Word read GetLParamHi write SetLParamHi;
  end;

  TWMSizeClipboard = class(TWMNoParams)
  public
    property Viewer: HWND read GetWParamHWND write SetWParamHWND;
    property RC: THandle read GetLParamHandle write SetLParamHandle;
  end;

  TWMSpoolerStatus = class(TWMNoParams)
  public
    property JobStatus: Integer read GetWParam write SetWParam;
    property JobsLeft: Word read GetLParamLo write SetLParamLo;
  end;

  TWMStyleChange = class(TWMNoParams)
  protected
    function GetStyleStruct: TStyleStruct;
    procedure SetStyleStruct(const Value: TStyleStruct);
  public
    property StyleType: Integer read GetWParam write SetWParam;
    property StyleStruct: TStyleStruct read GetStyleStruct write SetStyleStruct;
  end;

  TWMStyleChanged = TWMStyleChange;
  TWMStyleChanging = TWMStyleChange;

  TWMSysChar = TWMKey;
  TWMSysColorChange = TWMNoParams;

  TWMSysCommand = class(TWMNoParams)
  public
    property CmdType: Integer read GetWParam write SetWParam;

    { CmdType = SC_HOTKEY }
    property Viewer: HWND read GetLParamHWND write SetLParamHWND;

    { CmdType = SC_KEYMENU }
    property Key: Word read GetLParamLo write SetLParamLo;

    { CmdType = SC_CLOSE, SC_HSCROLL, SC_MAXIMIZE, SC_MINIMIZE, SC_MOUSEMENU, SC_MOVE,
      SC_NEXTWINDOW, SC_PREVWINDOW, SC_RESTORE, SC_SCREENSAVE, SC_SIZE,
      SC_TASKLIST, SC_VSCROLL }
    property XPos: Smallint read GetLParamLoSmall write SetLParamLoSmall;
    property YPos: Smallint read GetLParamHiSmall write SetLParamHiSmall;
  end;

  TWMSysDeadChar = class(TWMNoParams)
  public
    property CharCode: Word read GetWParamLo write SetWParamLo;
    property Redraw: Integer read GetLParam write SetLParam;
  end;

  TWMSysKeyDown = TWMKey;
  TWMSysKeyUp = TWMKey;

  TWMSystemError = class(TWMNoParams)
  public
    property ErrSpec: Word read GetWParamLo write SetWParamLo;
  end;

  TWMTimeChange = TWMNoParams;

  TWMTimer = class(TWMNoParams)
  protected
    function GetTimerProc: TFarProc;
    procedure SetTimerProc(const Value: TFarProc);
  public
    property TimerID: Integer read GetWParam write SetWParam;
    property TimerProc: TFarProc read GetTimerProc write SetTimerProc;
  end;

  TWMUIState = class(TWMNoParams)
  public
    property Action: Word read GetWParamLo write SetWParamLo;
    property Flags: Word read GetWParamHi write SetWParamHi;
  end;

  TWMChangeUIState = TWMUIState;
  TWMUpdateUIState = TWMUIState;
  TWMQueryUIState = TWMNoParams;

  TWMUndo = TWMNoParams;

  TWMVKeyToItem = TWMCharToItem;

  TWMVScroll = TWMScroll;

  TWMVScrollClipboard = class(TWMNoParams)
  public
    property Viewer: HWND read GetWParamHWND write SetWParamHWND;
    property ScrollCode: Word read GetLParamLo write SetLParamLo;
    property ThumbPos: Word read GetLParamHi write SetLParamHi;
  end;

  TWMWindowPosChanged = TWMWindowPosMsg;
  TWMWindowPosChanging = TWMWindowPosMsg;

  TWMWinIniChange = class(TWMNoParams)
  public
    property Section: LPSTR read GetLParamLPSTR write SetLParamLPSTR;
    property WParam;
  end;

  TWMSettingChange = class(TWMNoParams)
  public
    property Flag: Integer read GetWParam write SetWParam;
    property Section: LPSTR read GetLParamLPSTR write SetLParamLPSTR;
  end;

  TWMHelp = class(TWMNoParams)
  protected
    function GetHelpInfo: THelpInfo;
    procedure SetHelpInfo(Value: THelpInfo);
  public
    property HelpInfo: THelpInfo read GetHelpInfo write SetHelpInfo;
  end;

  TWMDisplayChange = class(TWMNoParams)
  public
    property BitsPerPixel: Integer read GetWParam write SetWParam;
    property Width: Word read GetLParamLo write SetLParamLo;
    property HEight: Word read GetLParamHi write SetLParamHi;
  end;

  TWMContextMenu = class(TWMPosition)
  public
    property hWnd: HWND read GetWParamHWND write SetWParamHWND;
  end;

  TWMPrint = class(TWMPosition)
  public
    property DC: HDC read GetWParamHDC write SetWParamHDC;
    property Flags: Integer read GetLParam write SetLParam;
  end;

  TWMPrintClient = TWMPrint;

function UnwrapMessage(Message: TObject): TMessage;

function SendTextMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: string): LRESULT;
function SendGetTextMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM;
 var lParam: string; BufferSize: Integer = 1024; ResultIsLen: Boolean = True): LRESULT;

function SendStructMessage(Handle: HWND; Msg: UINT; WParam: WPARAM; const LParam): LRESULT;
function SendGetStructMessage(Handle: HWND; Msg: UINT; WParam: WPARAM;
  var LParam; InitFromLParam: Boolean = False): LRESULT;

implementation

uses
  System.Reflection, System.Runtime.InteropServices, System.Security,
  {$IFDEF CF}CFUtils,{$ENDIF}SysConst;


const
  user32 = 'user32.dll';

{$IFNDEF CF}
[SuppressUnmanagedCodeSecurity]
[DllImport(user32, CharSet = CharSet.Auto, SetLastError = False, EntryPoint = 'SendMessage')]
function SendMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; external;
{$ENDIF}

function UnwrapMessage(Message: TObject): TMessage;
begin
  if TObject(Message) is TMessageCracker then
    Result := TMessageCracker(Message).OriginalMessage
  else
    Result := TMessage(Message);
end;

function SendTextMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: string): LRESULT;
var
  Mem: IntPtr;
begin
  Mem := Marshal.StringToHGlobalAuto(lParam);
  try
    Result := SendMessage(hWnd, Msg, wParam, LongInt(Mem));
  finally
    Marshal.FreeHGlobal(Mem);
  end;
end;

function SendGetTextMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM;
  var lParam: string; BufferSize: Integer = 1024; ResultIsLen: Boolean = True): LRESULT;
var
  Mem: IntPtr;
begin
  Mem := Marshal.AllocHGlobal((BufferSize + 1) * Marshal.SystemDefaultCharSize);
  try
    Marshal.WriteInt16(Mem, 0, BufferSize);
    Result := SendMessage(hWnd, Msg, wParam, LongInt(Mem));
    if ResultIsLen then BufferSize := Result;
    lParam := Marshal.PtrToStringAuto(Mem, BufferSize);
  finally
    Marshal.FreeHGlobal(Mem);
  end;
end;

function SendStructMessage(Handle: HWND; Msg: UINT; WParam: WPARAM; const LParam): LRESULT;
var
  Buffer: IntPtr;
begin
  Buffer := Marshal.AllocHGlobal(Marshal.SizeOf(TypeOf(TObject(LParam))));
  try
    Marshal.StructureToPtr(TObject(LParam), Buffer, False);
    Result := SendMessage(Handle, Msg, WParam, LongInt(Buffer));
  finally
    Marshal.DestroyStructure(Buffer, TypeOf(LParam));
    Marshal.FreeHGlobal(Buffer);
  end;
end;

function SendGetStructMessage(Handle: HWND; Msg: UINT; WParam: WPARAM;
  var LParam; InitFromLParam: Boolean = False): LRESULT;
var
  Buffer: IntPtr;
  Size: Cardinal;
begin
  Size := Marshal.SizeOf(TypeOf(TObject(LParam)));
  Buffer := Marshal.AllocHGlobal(Size);
  try
    if InitFromLParam then
      Marshal.StructureToPtr(TObject(LParam), Buffer, False);
    Result := SendMessage(Handle, Msg, WParam, LongInt(Buffer));
    LParam := Marshal.PtrToStructure(Buffer, TypeOf(LParam));
  finally
    Marshal.DestroyStructure(Buffer, TypeOf(LParam));
    Marshal.FreeHGlobal(Buffer);
  end;
end;

{ TMessage }

constructor TMessage.Create;
begin
  inherited Create;
end;

constructor TMessage.Create(Msg: Cardinal; WParam, LParam: Integer);
begin
  inherited Create;
  Self.Msg := Msg;
  Self.WParam := WParam;
  Self.LParam := LParam;
end;

constructor TMessage.Create(Message: TMessageCracker);
begin
  inherited Create;
  Self.Msg := Message.OriginalMessage.Msg;
  Self.WParam := Message.OriginalMessage.WParam;
  Self.LParam := Message.OriginalMessage.LParam;
  Self.Result := Message.OriginalMessage.Result;
end;

constructor TMessage.Create(Message: TMessage);
begin
  inherited Create;
  Self.Msg := Message.Msg;
  Self.WParam := Message.WParam;
  Self.LParam := Message.LParam;
  Self.Result := Message.Result;
end;

function TMessage.GetLParamHi: Word;
begin
  Result := LParam shr 16;
end;

function TMessage.GetLParamLo: Word;
begin
  Result := LParam and $FFFF;
end;

function TMessage.GetWParamHi: Word;
begin
  Result := WParam shr 16;
end;

function TMessage.GetWParamLo: Word;
begin
  Result := WParam and $FFFF;
end;

procedure TMessage.SetLParamHi(const Value: Word);
begin
  LParam := (LParam and $0000FFFF) or (Value shl 16);
end;

procedure TMessage.SetLParamLo(const Value: Word);
begin
  LParam := (LParam and $FFFF0000) or Value;
end;

procedure TMessage.SetWParamHi(const Value: Word);
begin
  WParam := (WParam and $0000FFFF) or (Value shl 16);
end;

procedure TMessage.SetWParamLo(const Value: Word);
begin
  WParam := (WParam and $FFFF0000) or Value;
end;

function TMessage.ToType(ToType: System.Type; Provider: IFormatProvider): TObject;
var
  FindParams: array of System.Type;
  CallParams: array of TObject;
  CtorInfo: ConstructorInfo;
begin
  if ToType.IsSubclassOf(TypeOf(TMessageCracker)) then
  begin
    // Construct and instance of the type
    // Result := SystemTypeToClass(ToType).Create(Self);
    SetLength(FindParams, 1);
    FindParams[0] := GetType;
    CtorInfo := ToType.GetConstructor(FindParams);
    if CtorInfo <> nil then
    begin
      SetLength(CallParams, 1);
      CallParams[0] := Self;
      Result := CtorInfo.Invoke(CallParams);
      Exit;
    end;
  end;

  Invalid;
  Result := nil;
end;

{ TMessageCracker }

constructor TMessageCracker.Create;
begin
  inherited Create;
  FMessage := TMessage.Create;
end;

constructor TMessageCracker.Create(Message: TMessage);
begin
  inherited Create;
  FMessage := Message;
end;

function TMessageCracker.GetLParam: Integer;
begin
  Result := FMessage.LParam;
end;

function TMessageCracker.GetLParamBool: LongBool;
begin
  Result := LongBool(LParam);
end;

function TMessageCracker.GetLParamHandle: THandle;
begin
  Result := THandle(LParam);
end;

function TMessageCracker.GetLParamHi: Word;
begin
  Result := FMessage.LParamHi;
end;

function TMessageCracker.GetLParamHICON: HICON;
begin
  Result := HICON(LParam);
end;

function TMessageCracker.GetLParamHiSmall: SmallInt;
begin
  Result := SmallInt(FMessage.LParamHi);
end;

function TMessageCracker.GetLParamHiWordBool: WordBool;
begin
  Result := WordBool(LParamHi);
end;

function TMessageCracker.GetLParamHMENU: HMENU;
begin
  Result := HMENU(LParam);
end;

function TMessageCracker.GetLParamHWND: HWND;
begin
  Result := HWND(LParam);
end;

function TMessageCracker.GetLParamLo: Word;
begin
  Result := FMessage.LParamLo;
end;

function TMessageCracker.GetLParamLoSmall: SmallInt;
begin
  Result := SmallInt(FMessage.LParamLo);
end;

function TMessageCracker.GetLParamLoWordBool: WordBool;
begin
  Result := WordBool(LParamLo);
end;

function TMessageCracker.GetLParamLPSTR: LPSTR;
begin
  Result := Marshal.PtrToStringAuto(IntPtr(LParam));
end;

function TMessageCracker.GetMsg: Cardinal;
begin
  Result := FMessage.Msg;
end;

function TMessageCracker.GetResult: Integer;
begin
  Result := FMessage.Result;
end;

function TMessageCracker.GetWParam: Integer;
begin
  Result := FMessage.WParam;
end;

function TMessageCracker.GetWParamBool: LongBool;
begin
  Result := LongBool(WParam);
end;

function TMessageCracker.GetWParamHandle: THandle;
begin
  Result := THandle(WParam);
end;

function TMessageCracker.GetWParamHDC: HDC;
begin
  Result := HDC(WParam);
end;

function TMessageCracker.GetWParamHFONT: HFONT;
begin
  Result := HFONT(WParam);
end;

function TMessageCracker.GetWParamHi: Word;
begin
  Result := FMessage.WParamHi;
end;

function TMessageCracker.GetWParamHiSmall: SmallInt;
begin
  Result := SmallInt(FMessage.WParamHi);
end;

function TMessageCracker.GetWParamHiWordBool: WordBool;
begin
  Result := WordBool(WParamHi);
end;

function TMessageCracker.GetWParamHMENU: HMENU;
begin
  Result := HMENU(WParam);
end;

function TMessageCracker.GetWParamHRGN: HRGN;
begin
  Result := HRGN(WParam);
end;

function TMessageCracker.GetWParamHWND: HWND;
begin
  Result := HWND(WParam);
end;

function TMessageCracker.GetWParamLo: Word;
begin
  Result := FMessage.WParamLo;
end;

function TMessageCracker.GetWParamLoSmall: SmallInt;
begin
  Result := SmallInt(FMessage.WParamLo);
end;

function TMessageCracker.GetWParamLoWordBool: WordBool;
begin
  Result := WordBool(WParamLo);
end;

function TMessageCracker.GetWParamLPSTR: LPSTR;
begin
  Result := Marshal.PtrToStringAuto(IntPtr(LParam));
end;

procedure TMessageCracker.SetLParam(const Value: Integer);
begin
  FMessage.LParam := Value;
end;

procedure TMessageCracker.SetLParamBool(const Value: LongBool);
begin
  LParam := Integer(Value);
end;

procedure TMessageCracker.SetLParamHandle(const Value: THandle);
begin
  LParam := Integer(Value);
end;

procedure TMessageCracker.SetLParamHi(const Value: Word);
begin
  FMessage.LParamHi := Value;
end;

procedure TMessageCracker.SetLParamHICON(const Value: HICON);
begin
  LParam := Integer(Value);
end;

procedure TMessageCracker.SetLParamHiSmall(const Value: SmallInt);
begin
  FMessage.LParamHi := Word(Value);
end;

procedure TMessageCracker.SetLParamHiWordBool(const Value: WordBool);
begin
  LParamHi := Word(Value);
end;

procedure TMessageCracker.SetLParamHMENU(const Value: HMENU);
begin
  LParam := Integer(Value);
end;

procedure TMessageCracker.SetLParamHWND(const Value: HWND);
begin
  LParam := Integer(Value);
end;

procedure TMessageCracker.SetLParamLo(const Value: Word);
begin
  FMessage.LParamLo := Value;
end;

procedure TMessageCracker.SetLParamLoSmall(const Value: SmallInt);
begin
  FMessage.LParamLo := Word(Value);
end;

procedure TMessageCracker.SetLParamLoWordBool(const Value: WordBool);
begin
  LParamLo := Word(Value);
end;

procedure TMessageCracker.SetLParamLPSTR(const Value: LPSTR);
var
  Bytes: TBytes;
begin
  Bytes := PlatformBytesOf(Value);
  Marshal.Copy(Bytes, 0, IntPtr(LParam), Length(Bytes));
end;

procedure TMessageCracker.SetMsg(const Value: Cardinal);
begin
  FMessage.Msg := Value;
end;

procedure TMessageCracker.SetResult(const Value: Integer);
begin
  FMessage.Result := Value;
end;

procedure TMessageCracker.SetWParam(const Value: Integer);
begin
  FMessage.WParam := Value;
end;

procedure TMessageCracker.SetWParamBool(const Value: LongBool);
begin
  WParam := Integer(Value);
end;

procedure TMessageCracker.SetWParamHandle(const Value: THandle);
begin
  WParam := Integer(Value);
end;

procedure TMessageCracker.SetWParamHDC(const Value: HDC);
begin
  WParam := Integer(Value);
end;

procedure TMessageCracker.SetWParamHFONT(const Value: HFONT);
begin
  WParam := Integer(Value);
end;

procedure TMessageCracker.SetWParamHi(const Value: Word);
begin
  FMessage.WParamHi := Value;
end;

procedure TMessageCracker.SetWParamHiSmall(const Value: SmallInt);
begin
  FMessage.WParamHi := Word(Value);
end;

procedure TMessageCracker.SetWParamHiWordBool(const Value: WordBool);
begin
  WParamHi := Word(Value);
end;

procedure TMessageCracker.SetWParamHMENU(const Value: HMENU);
begin
  WParam := Integer(Value);
end;

procedure TMessageCracker.SetWParamHRGN(const Value: HRGN);
begin
  LParam := Integer(Value);
end;

procedure TMessageCracker.SetWParamHWND(const Value: HWND);
begin
  WParam := Integer(Value);
end;

procedure TMessageCracker.SetWParamLo(const Value: Word);
begin
  FMessage.WParamLo := Value;
end;

procedure TMessageCracker.SetWParamLoSmall(const Value: SmallInt);
begin
  FMessage.WParamLo := Word(Value);
end;

procedure TMessageCracker.SetWParamLoWordBool(const Value: WordBool);
begin
  WParamLo := Word(Value);
end;

procedure TMessageCracker.SetWParamLPSTR(const Value: LPSTR);
var
  Bytes: TBytes;
begin
  Bytes := PlatformBytesOf(Value);
  Marshal.Copy(Bytes, 0, IntPtr(WParam), Length(Bytes));
end;

{ TWMPosition}

function TWMPosition.GetSmallPoint: TSmallPoint;
begin
  Result.X := XPos;
  Result.Y := YPos;
end;

procedure TWMPosition.SetSmallPoint(Value: TSmallPoint);
begin
  XPos := Value.X;
  YPos := Value.Y;
end;

{ TWMWindowPosMsg }

function TWMWindowPosMsg.GetWindowPosIsNil: Boolean;
begin
  Result := OriginalMessage.LParam = 0;
end;

function TWMWindowPosMsg.GetWindowPos: TWindowPos;
begin
  Result := TWindowPos(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TWindowPos)));
end;

procedure TWMWindowPosMsg.SetWindowPos(Value: TWindowPos);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMChooseFont_GetLogFont }

function TWMChooseFont_GetLogFont.GetLogFont: IntPtr;
begin
  Result := IntPtr(LParam);
end;

procedure TWMChooseFont_GetLogFont.SetLogFont(const Value: IntPtr);
begin
  LParam := Integer(Value);
end;

{ TWMCompareItem }

function TWMCompareItem.GetCompareItemStruct: TCompareItemStruct;
begin
  Result := TCompareItemStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TCompareItemStruct)));
end;

procedure TWMCompareItem.SetCompareItemStruct(Value: TCompareItemStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMCopyData }

function TWMCopyData.GetCopyDataStruct: TCopyDataStruct;
begin
  Result := TCopyDataStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TCopyDataStruct)));
end;

procedure TWMCopyData.SetCopyDataStruct(const Value: TCopyDataStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMCreate }

function TWMCreate.GetCreateStruct: TCreateStruct;
begin
  Result := TCreateStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TCreateStruct)));
end;

procedure TWMCreate.SetCreateStruct(const Value: TCreateStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMDeleteItem }

function TWMDeleteItem.GetDeleteItemStruct: TDeleteItemStruct;
begin
  Result := TDeleteItemStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TDeleteItemStruct)));
end;

procedure TWMDeleteItem.SetDeleteItemStruct(Value: TDeleteItemStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMDrawItem }

function TWMDrawItem.GetDrawItemStruct: TDrawItemStruct;
begin
  Result := TDrawItemStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TDrawItemStruct)));
end;

procedure TWMDrawItem.SetDrawItemStruct(Value: TDrawItemStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMGetMinMaxInfo }

function TWMGetMinMaxInfo.GetMinMaxInfo: TMinMaxInfo;
begin
  Result := TMinMaxInfo(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TMinMaxInfo)));
end;

procedure TWMGetMinMaxInfo.SetMinMaxInfo(Value: TMinMaxInfo);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMMDICreate }

{$IFNDEF CF}
function TWMMDICreate.GetMDICreateStruct: TMDICreateStruct;
begin
  Result := TMDICreateStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TMDICreateStruct)));
end;

procedure TWMMDICreate.SetMDICreateStruct(Value: TMDICreateStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;
{$ENDIF}

{ TWMMeasureItem }

function TWMMeasureItem.GetMeasureItemStruct: TMeasureItemStruct;
begin
  Result := TMeasureItemStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TMeasureItemStruct)));
end;

procedure TWMMeasureItem.SetMeasureItemStruct(Value: TMeasureItemStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMMenuChar }

function TWMMenuChar.GetChar: Char;
begin
  Result := Char(WParamLo);
end;

procedure TWMMenuChar.SetChar(const Value: Char);
begin
  WParamLo := Word(Value);
end;

{ TWMMoving }

function TWMMoving.GetRect: TRect;
begin
  Result := TRect(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TRect)));
end;

procedure TWMMoving.SetRect(const Value: TRect);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMNCCalcSize }

function TWMNCCalcSize.GetNCCalcSizeParams: TNCCalcSizeParams;
begin
  Result := TNCCalcSizeParams(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TNCCalcSizeParams)));
end;

procedure TWMNCCalcSize.SetNCCalcSizeParams(Value: TNCCalcSizeParams);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMNCCreate }

function TWMNCCreate.GetCreateStruct: TCreateStruct;
begin
  Result := TCreateStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TCreateStruct)));
end;

procedure TWMNCCreate.SetCreateStruct(const Value: TCreateStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMNotify }

function TWMNotify.GetNMHdr: TNMHdr;
begin
  Result := TNMHdr(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TNMHdr)));
end;

procedure TWMNotify.SetNMHdr(Value: TNMHdr);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMStyleChange }

function TWMStyleChange.GetStyleStruct: TStyleStruct;
begin
  Result := TStyleStruct(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(TStyleStruct)));
end;

procedure TWMStyleChange.SetStyleStruct(const Value: TStyleStruct);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TWMTimer }

function TWMTimer.GetTimerProc: TFarProc;
begin
  Result := TFarProc(LParam);
end;

procedure TWMTimer.SetTimerProc(const Value: TFarProc);
begin
  LParam := Integer(Value);
end;

{ TWWHelp }

function TWMHelp.GetHelpInfo: THelpInfo;
begin
  Result := THelpInfo(Marshal.PtrToStructure(IntPtr(LParam), TypeOf(THelpInfo)));
end;

procedure TWMHelp.SetHelpInfo(Value: THelpInfo);
begin
  Marshal.StructureToPtr(TObject(Value), IntPtr(OriginalMessage.LParam), False);
end;

{ TMessageBase }

function TMessageBase.GetTypeCode: TypeCode;
begin
  Result := TypeCode.Object;
end;

procedure TMessageBase.Invalid;
begin
  raise Exception.Create(SInvalidTypeConversion);
end;

function TMessageBase.ToBoolean(Provider: IFormatProvider): Boolean;
begin
  Invalid;
  Result := False;
end;

function TMessageBase.ToByte(Provider: IFormatProvider): Byte;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToChar(Provider: IFormatProvider): Char;
begin
  Invalid;
  Result := #0;
end;

function TMessageBase.ToDateTime(Provider: IFormatProvider): DateTime;
begin
  Invalid;
end;

function TMessageBase.ToDecimal(Provider: IFormatProvider): Decimal;
begin
  Invalid;
end;

function TMessageBase.ToDouble(Provider: IFormatProvider): Double;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToInt16(Provider: IFormatProvider): SmallInt;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToInt32(Provider: IFormatProvider): Integer;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToInt64(Provider: IFormatProvider): Int64;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToSByte(Provider: IFormatProvider): ShortInt;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToString(Provider: IFormatProvider): string;
begin
  Invalid;
  Result := '';
end;

function TMessageBase.ToSingle(Provider: IFormatProvider): Single;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToType(ToType: System.Type; Provider: IFormatProvider): TObject;
begin
  Invalid;
  Result := nil;
end;

function TMessageBase.ToUInt16(Provider: IFormatProvider): Word;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToUInt32(Provider: IFormatProvider): Cardinal;
begin
  Invalid;
  Result := 0;
end;

function TMessageBase.ToUInt64(Provider: IFormatProvider): UInt64;
begin
  Invalid;
  Result := 0;
end;

end.
